package com.jxit.sdkdemo.fragment;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxsdk.BarcodeFormat;
import com.jxit.printer.jxsdk.JXGlobalPrinter;
import com.jxit.printer.jxsdk.JXPrinter;
import com.jxit.printer.model.JXPrinterStatus;
import com.jxit.printer.utils.BitmapTools;
import com.jxit.sdkdemo.BaseActivity;
import com.jxit.sdkdemo.HomeActivity;
import com.jxit.sdkdemo.MainActivity;
import com.jxit.sdkdemo.PrinterManager;
import com.jxit.sdkdemo.R;
import com.jxit.sdkdemo.databinding.FragmentGlobalBinding;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

import static java.lang.Math.sin;


public class GlobalFragment extends Fragment implements View.OnClickListener {
    private FragmentGlobalBinding bd;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (bd == null) {
            bd = FragmentGlobalBinding.inflate(inflater, container, false);
        }
        bd.setClickHandler(this);
        return bd.getRoot();
    }

    LinePrinter mLinePrinter = new LinePrinter();
    PagePrinter mPagePrinter = new PagePrinter();

    @Override
    public void onClick(View v) {
        JXInterfaceAPI api = PrinterManager.getInstance().getApi();
        if (api == null || !api.isConnected()) {
            ((BaseActivity) getActivity()).toast(R.string.warn_connect_printer);
            return;
        }
        if (mLinePrinter.printer == null) {
            mLinePrinter.printer = new JXGlobalPrinter(api, JXGlobalPrinter.PrintMode.Line);
        }

        if (mPagePrinter.printer == null) {
            mPagePrinter.printer = new JXGlobalPrinter(api, JXGlobalPrinter.PrintMode.Page);
        }

        if (bd.btnPrintState.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                JXPrinterStatus status =  mLinePrinter.printer.get_printer_status();
                if (status.isReady){
                    ((BaseActivity) getActivity()).toast(R.string.Leisure);
                }else if (status.isPrinting){
                    ((BaseActivity) getActivity()).toast(R.string.Printing);
                }else if (status.isOverHeat){
                    ((BaseActivity) getActivity()).toast(R.string.Overheating);
                }else if (status.isNoPaper){
                    ((BaseActivity) getActivity()).toast(R.string.NoPaper);
                }else if (status.isCoverOpened){
                    ((BaseActivity) getActivity()).toast(R.string.Open);
                }else if (status.isBatteryLow){
                    ((BaseActivity) getActivity()).toast(R.string.LowPower);
                }else {
                    ((BaseActivity) getActivity()).toast(R.string.isUnknownError);
                }

                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        }else if (bd.btnPrintCheck.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mLinePrinter.printer.print_check_page();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        }else if (bd.btnPrintLock.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                boolean succeed = mLinePrinter.printer.set_print_unlock();
                if (succeed){
                    ((BaseActivity) getActivity()).toast(R.string.UnlockSucceed);
                }else{
                    ((BaseActivity) getActivity()).toast(R.string.UnlockFail);
                }
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnLineAllCmd.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mLinePrinter.drawText();
                mLinePrinter.drawGraphic();
                mLinePrinter.drawBarcode1D();
                mLinePrinter.drawBarcode2D();
                mLinePrinter.drawLine();
                mLinePrinter.drawCurve();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnLineText.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mLinePrinter.drawText();

                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        }else if (bd.btnLineLine.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mLinePrinter.drawLine();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnLineGraphic.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mLinePrinter.drawGraphic();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();
        } else if (bd.btnLineBarcode1D.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mLinePrinter.drawBarcode1D();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnLineBarcode2D.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mLinePrinter.drawBarcode2D();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnLineCurve.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mLinePrinter.drawCurve();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageAllCmd.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mPagePrinter.drawText1();
                mPagePrinter.drawText();
                mPagePrinter.drawGraphic();
                mPagePrinter.drawBarcode1D();
                mPagePrinter.drawBarcode1D2();
                mPagePrinter.drawBarcode1D3();
                mPagePrinter.drawBarcode2D();
                mPagePrinter.drawLine();
                mPagePrinter.drawBox();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageText.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);

                mPagePrinter.drawText1();
                mPagePrinter.drawText();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageGraphic.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mPagePrinter.drawGraphic();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageBox.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mPagePrinter.drawBox();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        }else if (bd.btnPageBarcode1D.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mPagePrinter.drawBarcode1D();
                mPagePrinter.drawBarcode1D2();
                mPagePrinter.drawBarcode1D3();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageBarcode2D.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mPagePrinter.drawBarcode2D();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        } else if (bd.btnPageLine.equals(v)) {
            new Thread(() -> {
                ((BaseActivity) getActivity()).showProgress(R.string.printing);
                mPagePrinter.drawLine();
                ((BaseActivity) getActivity()).hideProgress();
            }).start();

        }
    }

    private class LinePrinter {
        JXGlobalPrinter printer;

        void drawText() {
            printer.line_setMaxPrintWidth(HomeActivity.selectMaxPrinterWidth);
            printer.line_reset();
            printer.line_drawText(getActivity().getString(R.string.TextDemo));
            printer.line_print();
            drawText1();
            printer.line_setAlign(0);
            printer.line_drawText(getActivity().getString(R.string.TextLeft));
            printer.line_print();

            printer.line_reset();
            printer.line_setAlign(1);
            printer.line_drawText(getActivity().getString(R.string.TextCenter));
            printer.line_print();

            printer.line_setAlign(2);
            printer.line_drawText(getActivity().getString(R.string.TextRight));
            printer.line_print();

            printer.line_reset();
            printer.line_drawText(getActivity().getString(R.string.LeftMargin));
            printer.line_print();
            printer.line_setLeftMargin(80);
            printer.line_drawText("abcDEFJLJGJLLJGKLJGLAJGLJGLJNDHJHGJHSGGUJGLJGlakghk1234");
            printer.line_print();

            printer.line_reset();
            printer.line_drawText(getActivity().getString(R.string.RightMargin));
            printer.line_print();
            printer.line_reset();
            printer.line_setRightMargin(80);
            printer.line_drawText("abcDEFJLJGJLLJGKLJGLAJGLJGLJNDHJHGJHSGGUJGLJGlakghk1234");
            printer.line_print();

            String rowSpace = getActivity().getString(R.string.SetLineSpace);
            printer.line_reset();
            printer.line_drawText(rowSpace + " 0mm");
            printer.line_print();
            printer.line_setLineSpacing(8);
            printer.line_drawText(rowSpace + " 1mm");
            printer.line_print();
            printer.line_setLineSpacing(16);
            printer.line_drawText(rowSpace + " 2mm");

            printer.line_print();
            String letterSpace = getActivity().getString(R.string.SetLetterSpace);

            printer.line_reset();
            printer.line_drawText(letterSpace + " 0mm");
            printer.line_print();
            printer.line_setLetterSpacing(8);
            printer.line_drawText(letterSpace + " 1mm");
            printer.line_print();
            printer.line_setLetterSpacing(16);
            printer.line_drawText(letterSpace + " 2mm");
            printer.line_print();

            printer.line_reset();
            printer.line_setFontBold(true);
            printer.line_drawText(getActivity().getString(R.string.TextBlod));
            printer.line_print();

            printer.line_reset();
            printer.line_setFontUnderline(true);
            printer.line_drawText(getActivity().getString(R.string.TextUnderLine));
            printer.line_print();

            printer.line_reset();
            printer.line_setFontItaly(true);
            printer.line_drawText(getActivity().getString(R.string.TextItalics));
            printer.line_print();

            printer.line_reset();
            printer.line_setFontReverse(true);
            printer.line_drawText(getActivity().getString(R.string.TextReverse));
            printer.line_print();

            printer.line_reset();
            printer.line_setFontBold(true);
            printer.line_setFontUnderline(true);
            printer.line_setFontItaly(true);
            printer.line_setFontReverse(true);
            printer.line_drawText(getActivity().getString(R.string.TextAll));
            printer.line_print();

            printer.line_reset();
            printer.line_drawText(getActivity().getString(R.string.TextFont));
            printer.line_print();
            printer.line_reset();
            for (int i = 0; i < 8; i++) {
                printer.line_setFontSize((i + 2) * 8);
                printer.line_drawText((i + 2) + "mm,");

            }
            printer.line_print();

            printer.line_reset();
            printer.line_drawText(getActivity().getString(R.string.TextScale));
            printer.line_print();

            printer.line_setFontScale(2, 1);
            printer.line_drawText(getActivity().getString(R.string.TextDoubleWidth));
            printer.line_print();

            printer.line_reset();
            printer.line_setFontScale(1, 2);
            printer.line_drawText(getActivity().getString(R.string.TextDoubleHeight));
            printer.line_print();

            printer.line_reset();
            printer.line_feed(96);


        }

        void drawText1() {
            //英语
            printer.line_drawText("Hello World");
            printer.line_print();
//中文
            printer.line_drawText("你好，世界");
            printer.line_print();
//法语
            printer.line_drawText("Bonjour, le monde.");
            printer.line_print();
//西班牙语
            printer.line_drawText("Hola, mundo.");
            printer.line_print();
//葡萄牙语
            printer.line_drawText("Olá Mundo");
            printer.line_print();
//俄语
            printer.line_drawText("Здравствуй, мир");
            printer.line_print();
//韩语
            printer.line_drawText("안녕하세요.");
            printer.line_print();
//孟加拉语
            printer.line_drawText("হ্যালো ওয়া");
            printer.line_print();
//德语
            printer.line_drawText("Hallo Welt");
            printer.line_print();
//日语
            printer.line_drawText("ハローワールド");
            printer.line_print();
//印地语
            printer.line_drawText("हेलो विश्व");
            printer.line_print();

//越南语
            printer.line_drawText("Chào thế giới");
            printer.line_print();
//丹麦语
            printer.line_drawText("Hej, World.");
            printer.line_print();
//挪威语
            printer.line_drawText("Hallo World");
            printer.line_print();
//意大利语
            printer.line_drawText("Ciao, Mondo.");
            printer.line_print();
        }

        void drawLine() {
            printer.line_setMaxPrintWidth(HomeActivity.selectMaxPrinterWidth);
            printer.line_reset();//清除缓存
            printer.line_drawText(getActivity().getString(R.string.LinePrint));
            printer.line_print();
            printer.line_feed(8);
            printer.line_drawLine(2, 100, true);
            printer.line_print();
            printer.line_drawLine(100, 2, false);
            printer.line_print();
            printer.line_feed(96);
        }
        

        void drawBarcode1D() {
            printer.line_setMaxPrintWidth(HomeActivity.selectMaxPrinterWidth);
            printer.line_reset();
            printer.line_drawText(getActivity().getString(R.string.BarcodeNoText));
            printer.line_print();
            printer.line_drawBarcode1D(300, 100, "0123456789", 0, BarcodeFormat.CODE_128);
            printer.line_print();

            printer.line_drawText(getActivity().getString(R.string.BarcodeTextBelow));
            printer.line_print();
            printer.line_setBarcode1DText(true, 24, false, 0, false);
            printer.line_drawBarcode1D(300, 100, "0123456789", 0, BarcodeFormat.CODE_128);
            printer.line_print();
            printer.line_feed(8);
            printer.line_drawText(getActivity().getString(R.string.BarcodeTextUp));
            printer.line_print();
            printer.line_setBarcode1DText(false, 24, true, 0, false);
            printer.line_drawBarcode1D(300, 100, "0123456789", 0, BarcodeFormat.CODE_128);
            printer.line_print();
            printer.line_feed(8);
            printer.line_setBarcode1DText(false, 24, true, 8, false);
            printer.line_drawBarcode1D(300, 100, "0123456789", 90, BarcodeFormat.CODE_128);
            printer.line_print();
            printer.line_feed(8);
            printer.line_setBarcode1DText(false, 24, true, 8, false);
            printer.line_drawBarcode1D(300, 100, "0123456789", 180, BarcodeFormat.CODE_128);
            printer.line_print();
            printer.line_feed(8);
            printer.line_setBarcode1DText(false, 24, true, 8, false);
            printer.line_drawBarcode1D(300, 100, "0123456789", 270, BarcodeFormat.CODE_128);
            printer.line_print();
            printer.line_feed(8);

            String type = getActivity().getString(R.string.Category);
            String content = getActivity().getString(R.string.Content);

            printer.line_drawText(type+"：UPC_A; "+content+"：123456789012\n");
            printer.line_drawBarcode1D(300, 100, "123456789012", 0, BarcodeFormat.UPC_A);
            printer.line_print();
            printer.line_drawText(type+"：UPC_E;" +content+"：04029311\n");
            printer.line_drawBarcode1D(300, 100, "04029311", 0, BarcodeFormat.UPC_E);
            printer.line_print();
            printer.line_drawText(type+"：EAN_8; " +content+"：12345670\n");
            printer.line_drawBarcode1D(300, 100, "12345670", 0, BarcodeFormat.EAN_8);
            printer.line_print();
            printer.line_drawText(type+"：EAN_13; " +content+"：1234567890128\n");
            printer.line_drawBarcode1D(300, 100, "1234567890128", 0, BarcodeFormat.EAN_13);
            printer.line_print();
            printer.line_drawText(type+"：CODE_39; " +content+"：123456789\n");
            printer.line_drawBarcode1D(300, 100, "123456789", 0, BarcodeFormat.CODE_39);
            printer.line_print();
            printer.line_drawText(type+"：CODE_93; " +content+"：123456789\n");
            printer.line_drawBarcode1D(300, 100, "123456789", 0, BarcodeFormat.CODE_93);
            printer.line_print();
            printer.line_drawText(type+"：CODE_128; " +content+"：123456789\n");
            printer.line_drawBarcode1D(300, 100, "123456789", 0, BarcodeFormat.CODE_128);
            printer.line_print();
            printer.line_drawText(type+"：CODABAR; " +content+"：123456789\n");
            printer.line_drawBarcode1D(300, 100, "123456789", 0, BarcodeFormat.CODABAR);
            printer.line_print();
            printer.line_drawText(type+"：ITF; " +content+"：1234567890\n");
            printer.line_drawBarcode1D(300, 100, "1234567890", 0, BarcodeFormat.ITF);
            printer.line_print();
            printer.line_reset();
            printer.line_feed(96);
        }

        void drawBarcode2D() {
            printer.line_setMaxPrintWidth(HomeActivity.selectMaxPrinterWidth);
            printer.line_reset();
            printer.line_drawText(getActivity().getString(R.string.QrcodePrint)+"\n");
            String type = getActivity().getString(R.string.Category);
            String content = getActivity().getString(R.string.Content);
            printer.line_drawText(type+"：QR_CODE; "+content+"：1234567890\n");
            printer.line_drawBarcode2D(150, 150, "1234567890", 0, BarcodeFormat.QR_CODE);
            printer.line_print();
            printer.line_drawText(type+"：PDF_417; "+content+"：1234567890\n");
            printer.line_drawBarcode2D(240, 80, "1234567890", 0, BarcodeFormat.PDF_417);
            printer.line_print();
            printer.line_drawText(type+"：DATA_MATRIX; "+content+"：1234567890\n");
            printer.line_drawBarcode2D(150, 150, "1234567890", 0, BarcodeFormat.DATA_MATRIX);
            printer.line_print();
            printer.line_drawText(type+"：AZTEC; "+content+"：1234567890\n");
            printer.line_drawBarcode2D(150, 150, "1234567890", 0, BarcodeFormat.AZTEC);
            printer.line_print();

            printer.line_reset();
            printer.line_feed(96);
        }

        void drawGraphic() {
            printer.line_setMaxPrintWidth(HomeActivity.selectMaxPrinterWidth);
            printer.line_reset();
            printer.line_drawText(getActivity().getString(R.string.ImagePrint));
            printer.line_print();
            try {
                InputStream is = getResources().getAssets().open("logo.jpeg");
                Bitmap bmp = BitmapFactory.decodeStream(is);
                printer.line_setAlign(0);
                printer.line_drawGraphic(bmp);
                printer.line_print();

                is = getResources().getAssets().open("logo.jpeg");
                bmp = BitmapFactory.decodeStream(is);
                printer.line_setAlign(1);
                printer.line_drawGraphic(bmp);
                printer.line_print();

                is = getResources().getAssets().open("logo.jpeg");
                bmp = BitmapFactory.decodeStream(is);
                printer.line_drawGraphic(bmp);
                printer.line_setAlign(2);
                printer.line_print();
            } catch (Exception e) {
                e.printStackTrace();
            }

            printer.line_reset();
            printer.line_feed(96);
        }

        public void drawCurve() {
            printer.line_setMaxPrintWidth(HomeActivity.selectMaxPrinterWidth);
            printer.line_reset();
            printer.line_drawText(getActivity().getString(R.string.CurvePrint));
            printer.line_print();
            printer.line_drawLineSegments(30, 230);
            printer.line_drawLineSegments(130, 130);
            int x;
            for (int i = 1; i <= 512; i++) {
                x = (int) (sin(Math.PI * i / 128) * 100 + 130);
                printer.line_drawLineSegments(130, 130, x, x);
            }

            printer.line_reset();
            printer.line_feed(120);
        }
    }

    private class PagePrinter {
        JXGlobalPrinter printer;

        void drawText() {
            int y = 0;
            int maxWidth = HomeActivity.selectMaxPrinterWidth;
            printer.page_setup(maxWidth, 800, 0);
            printer.page_resetFontSettings();
            printer.page_drawText(8, y, maxWidth, y + 30, 0, true, getActivity().getString(R.string.TextDemo));
            y += 30;
            printer.page_resetFontSettings();
            printer.page_setLineSpacing(16);
            String rowSpace = getActivity().getString(R.string.SetLineSpace);
            printer.page_drawText(8, y, maxWidth, y + 100, 0, false, rowSpace+"2mm  first\n"+rowSpace+"2mm  second");
            y += 80;
            printer.page_resetFontSettings();
            printer.page_setLetterSpacing(0);
            String letterSpace = getActivity().getString(R.string.SetLetterSpace);
            printer.page_drawText(8, y, 270, y + 30, 0, true, letterSpace+"0mm");
            printer.page_setLetterSpacing(8);
            printer.page_drawText(270, y, 390, y + 30, 0, true, ",1mm");
            printer.page_setLetterSpacing(16);
            printer.page_drawText(390, y, 510, y + 30, 0, true, ",2mm");
            y += 30;
            printer.page_resetFontSettings();
            printer.page_setFontBold(true);
            printer.page_drawText(8, y, 350, y + 30, 0, true, getActivity().getString(R.string.TextBlod));

            y += 30;
            printer.page_resetFontSettings();
            printer.page_setFontUnderline(true);
            printer.page_drawText(8, y, 350, y + 30, 0, true, getActivity().getString(R.string.TextUnderLine)+"\n");
            y += 30;
            printer.page_resetFontSettings();
            printer.page_setFontItaly(true);
            printer.page_drawText(8, y, 350, y + 30, 0, true, getActivity().getString(R.string.TextItalics)+"\n");
            y += 30;
            printer.page_resetFontSettings();
            printer.page_setFontReverse(true);
            printer.page_drawText(8, y, 350, y + 30, 0, true, getActivity().getString(R.string.TextReverse)+"\n");
            y += 30;
            printer.page_resetFontSettings();
            printer.page_setFontBold(true);
            printer.page_setFontUnderline(true);
            printer.page_setFontItaly(true);
            printer.page_setFontReverse(true);
            printer.page_drawText(8, y, 350, y + 30, 0, true, getActivity().getString(R.string.TextAll)+"\n");
            y += 30;
            printer.page_resetFontSettings();
            printer.page_drawText(8, y, 350, y + 30, 0, true, getActivity().getString(R.string.TextFont)+"\n");
            y += 30;
            printer.page_setFontSize(16);
            printer.page_drawText(8, y + 8 * 4, 56, y + 8 * 7, 0, true, "2mm");
            printer.page_setFontSize(24);
            printer.page_drawText(56, y + 8 * 3, 128, y + 8 * 7, 0, true, "3mm");
            printer.page_setFontSize(32);
            printer.page_drawText(128, y + 8 * 2, 224, y + 8 * 7, 0, true, "4mm");
            printer.page_setFontSize(40);
            printer.page_drawText(224, y + 8 * 1, 344, y + 8 * 7, 0, true, "5mm");
            printer.page_setFontSize(48);
            printer.page_drawText(344, y, 488, y + 8 * 7, 0, true, "6mm");
            y += 56;
            printer.page_setFontSize(56);
            printer.page_drawText(8, y + 8 * 2, 176, y + 8 * 10, 0, true, "7mm");
            printer.page_setFontSize(64);
            printer.page_drawText(176, y + 8 * 1, 368, y + 8 * 10, 0, true, "8mm");
            printer.page_setFontSize(72);
            printer.page_drawText(368, y, 584, y + 8 * 10, 0, true, "9mm");
            y += 80;
            printer.page_resetFontSettings();
            printer.page_drawText(8, y, 350, y + 30, 0, true, getActivity().getString(R.string.TextScale)+"\n");
            y += 30;
            printer.page_setFontScale(2, 1);
            printer.page_drawText(8, y, 350, y + 30, 0, true, getActivity().getString(R.string.TextDoubleWidth)+"\n");
            y += 30;
            printer.page_setFontScale(1, 2);
            printer.page_drawText(8, y, 350, y + 60, 0, true, getActivity().getString(R.string.TextDoubleHeight)+"\n");
            y += 60;
            printer.page_resetFontSettings();
            printer.page_drawText(8, y, 350, y + 30, 0, true, getActivity().getString(R.string.TextRotate)+":\n");
            y += 30;
            printer.page_setFontSize(24);
            printer.page_drawText(8, y, 168, y + 168, 0, true, getActivity().getString(R.string.TextRotate0));
            printer.page_drawText(8, y, 168, y + 168, 90, true, getActivity().getString(R.string.TextRotate90));
            printer.page_drawText(8, y, 168, y + 168, 180, true, getActivity().getString(R.string.TextRotate180));
            printer.page_drawText(8, y, 168, y + 168, 270, true, getActivity().getString(R.string.TextRotate270));
            printer.page_print();
        }
        void drawText1() {
            int y = 0;
            int maxWidth = HomeActivity.selectMaxPrinterWidth;
            printer.page_setup(maxWidth, 800, 0);
            printer.page_resetFontSettings();
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "Hello World\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "你好，世界\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "Bonjour, le monde\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "Hola, mundo\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "Olá Mundo\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "Здравствуй, мир\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "안녕하세요\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "হ্যালো ওয়ার্ল্ড\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "ハローワールドn");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "हेलो विश्व\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "Chào thế giới\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "Hej, World.\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "Hallo World\n");
            y += 30;
            printer.page_drawText(16, y, maxWidth, y + 30, 0, true, "Ciao, Mondo.\n");

            printer.page_print();

        }
        void drawGraphic() {
            int maxWidth = HomeActivity.selectMaxPrinterWidth;
            printer.page_setup(maxWidth, 800, 0);
            printer.page_resetFontSettings();
            printer.page_drawText(8, 0, maxWidth, 30, 0, true, getActivity().getString(R.string.ImagePrint));
            try {
                InputStream is = getResources().getAssets().open("logo.jpeg");
                Bitmap bmp = BitmapFactory.decodeStream(is);
                printer.page_drawGraphic(8, 30, bmp);
                printer.page_drawGraphic((maxWidth-bmp.getWidth())/2+8, 180, bmp);
                printer.page_drawGraphic((maxWidth-bmp.getWidth())-8, 330, bmp);
            } catch (Exception e) {
                e.printStackTrace();
            }
            printer.page_print();
        }

        void drawBarcode1D() {
            int maxWidth = HomeActivity.selectMaxPrinterWidth;
            printer.page_setup(maxWidth, 800, 0);
            String type = getActivity().getString(R.string.Category);
            String content = getActivity().getString(R.string.Content);
            int y = 0;
            printer.page_resetFontSettings();
            printer.page_drawText(8, y, 500, y + 70, 0, false, type+"：CODE128; "+content+"：0123456789\n"+getActivity().getString(R.string.BarcodeNoText)+":");
            y += 70;
            printer.page_drawBarcode1D(8, y, 240, 80, "0123456789", 0, BarcodeFormat.CODE_128);
            y += 100;
            printer.page_drawText(8, y, 500, y + 30, 0, true, getActivity().getString(R.string.BarcodeTextBelow)+":\n");
            y += 40;
            printer.page_setBarcode1DText(true, 24, false, 0, true);
            printer.page_drawBarcode1D(8, y, 240, 80, "0123456789", 0, BarcodeFormat.CODE_128);
            y += 130;
            printer.page_drawText(8, y, 500, y + 30, 0, true, getActivity().getString(R.string.BarcodeTextUp)+":\n");
            y += 40;
            printer.page_setBarcode1DText(false, 24, true, 0, true);
            printer.page_drawBarcode1D(8, y, 240, 80, "0123456789", 0, BarcodeFormat.CODE_128);
            y += 130;
            printer.page_drawText(8, y, 500, y + 30, 0, true, getActivity().getString(R.string.bar_Rotate270)+" 90，180，270\n");
            y += 40;
            printer.page_setBarcode1DText(true, 24, false, 0, true);
            printer.page_drawBarcode1D(8, y, 240, 80, "123456789", 90, BarcodeFormat.CODE_128);
            printer.page_setBarcode1DText(true, 24, false, 0, true);
            printer.page_drawBarcode1D(128, y, 240, 80, "123456789", 180, BarcodeFormat.CODE_128);
            printer.page_setBarcode1DText(true, 24, false, 0, true);
            printer.page_drawBarcode1D(388, y, 240, 80, "123456789", 270, BarcodeFormat.CODE_128);
            printer.page_print();
        }
        void drawBarcode1D2(){
            int maxWidth = HomeActivity.selectMaxPrinterWidth;
            printer.page_setup(maxWidth, 800, 0);
            String type = getActivity().getString(R.string.Category);
            String content = getActivity().getString(R.string.Content);
            int y = 0;
            printer.page_resetFontSettings();
            printer.page_drawText(8, y, 500, y + 30, 0, true,type+"：UPC_A; "+content+"：123456789012");
            y += 40;
            printer.page_drawBarcode1D(8, y, 300, 100, "123456789012", 0, BarcodeFormat.UPC_A);
            y += 110;
            printer.page_drawText(8, y, 500, y + 30, 0, true,type+"：UPC_E;" +content+"：04029311\n");
            y += 40;
            printer.page_drawBarcode1D(8, y, 300, 100, "04029311", 0, BarcodeFormat.UPC_E);
            y += 110;
            printer.page_drawText(8, y, 500, y + 30, 0, true,type+"：EAN_8; " +content+"：12345670\n");
            y += 40;
            printer.page_drawBarcode1D(8, y, 300, 100, "12345670", 0, BarcodeFormat.EAN_8);
            y += 110;
            printer.page_drawText(8, y, 500, y + 30, 0, true,type+"：EAN_13; " +content+"：1234567890128\n");
            y += 40;
            printer.page_drawBarcode1D(8, y, 300, 100, "1234567890128", 0, BarcodeFormat.EAN_13);
            y += 110;
            printer.page_drawText(8, y, 500, y + 30, 0, true,type+"：CODE_39; " +content+"：123456789\n");
            y += 40;
            printer.page_drawBarcode1D(8, y, 300, 100, "123456789", 0, BarcodeFormat.CODE_39);
            printer.page_print();
        }
        void drawBarcode1D3(){
            int maxWidth = HomeActivity.selectMaxPrinterWidth;
            printer.page_setup(maxWidth, 800, 0);
            String type = getActivity().getString(R.string.Category);
            String content = getActivity().getString(R.string.Content);
            int y = 0;
            printer.page_resetFontSettings();
            printer.page_drawText(8, y, 500, y + 30, 0, true,type+"：CODE128; " +content+"：123456789\n");
            y += 40;
            printer.page_drawBarcode1D(8, y, 300, 100, "123456789", 0, BarcodeFormat.CODE_128);
            y += 110;
            printer.page_drawText(8, y, 500, y + 30, 0, true,type+"：CODE_93; " +content+"：123456789\n");
            y += 40;
            printer.page_drawBarcode1D(8, y, 300, 100, "123456789", 0, BarcodeFormat.CODE_93);
            y += 110;
            printer.page_drawText(8, y, 500, y + 30, 0, true,type+"：CODABAR; " +content+"：123456789\n");
            y += 40;
            printer.page_drawBarcode1D(8, y, 300, 100, "123456789", 0, BarcodeFormat.CODABAR);
            y += 110;
            printer.page_drawText(8, y, 500, y + 30, 0, true,type+"：ITF; " +content+"：1234567890\n");
            y += 40;
            printer.page_drawBarcode1D(8, y, 300, 100, "1234567890", 0, BarcodeFormat.ITF);
            printer.page_print();
        }
        void drawBarcode2D() {
            int maxWidth = HomeActivity.selectMaxPrinterWidth;
            printer.page_setup(maxWidth, 800, 0);
            String type = getActivity().getString(R.string.Category);
            String content = getActivity().getString(R.string.Content);
            printer.page_resetFontSettings();
            int y = 0;
            printer.page_drawText(8, y, 500, y + 60, 0, false, getActivity().getString(R.string.QrcodePrint)+"：\n"+type+"：QR_CODE; "+content+"：1234567890\n");
            y += 60;
            printer.page_drawBarcode2D(8, y, 100, 100, "1234567890", 0, BarcodeFormat.QR_CODE);
            y += 110;
            printer.page_drawText(8, y, 500, y + 30, 0, false, type+"：PDF_417; "+content+"：1234567890\n");
            y += 30;
            printer.page_drawBarcode2D(8, y, 300, 100, "1234567890", 0, BarcodeFormat.PDF_417);
            y += 110;
            printer.page_drawText(8, y, 500, y + 30, 0, false, type+"：DATA_MATRIX; "+content+"：1234567890\n");
            y += 30;
            printer.page_drawBarcode2D(8, y, 200, 200, "1234567890", 0, BarcodeFormat.DATA_MATRIX);
            y += 210;
            printer.page_drawText(8, y, 500, y + 30, 0, false, type+"：AZTEC; "+content+"：1234567890\n");
            y += 30;
            printer.page_drawBarcode2D(8, y, 150, 150, "1234567890", 0, BarcodeFormat.AZTEC);
            printer.page_print();
        }

        void drawLine() {
            int maxWidth = HomeActivity.selectMaxPrinterWidth;
            printer.page_resetFontSettings();
            printer.page_setup(maxWidth, 400, 0);
            printer.page_drawText(16, 0, maxWidth,  30, 0, true, getActivity().getString(R.string.LinePrint));
            printer.page_drawLine(8, 40, 200, 40, 5, true);
            printer.page_drawLine(8, 50, 8, 200, 5, false);
            printer.page_print();
        }
        void  drawBox(){
            int maxWidth = HomeActivity.selectMaxPrinterWidth;
            printer.page_setup(maxWidth, 400, 0);
            printer.page_resetFontSettings();
            printer.page_drawText(16, 0, maxWidth,  30, 0, true, getActivity().getString(R.string.BoxPrint));
            printer.page_drawBox( 0, 40, 310, 110, 2, false);
            printer.page_drawBox( 0, 190, 310, 110, 2, true);
            printer.page_print();
        }
    }
}
