package com.jxit.sdkdemo;

import android.app.ProgressDialog;
import android.support.v7.app.AppCompatActivity;
import android.widget.Toast;

public class BaseActivity extends AppCompatActivity {
    private ProgressDialog mProgress;

    public void showProgress(String msg) {
        runOnUiThread(() -> {
            if (mProgress == null) {
                mProgress = new ProgressDialog(this);
            }
            mProgress.setMessage(msg);
            mProgress.show();
        });
    }

    public void showProgress(int msgId) {
        runOnUiThread(() -> {
            if (mProgress == null) {
                mProgress = new ProgressDialog(this);
            }
            mProgress.setMessage(getResources().getString(msgId));
            mProgress.show();
        });
    }

    public void hideProgress() {
        if (mProgress != null && mProgress.isShowing()) {
            runOnUiThread(() -> mProgress.dismiss());
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        hideProgress();
    }

    public void toast(String msg) {
        runOnUiThread(() -> Toast.makeText(this, msg, Toast.LENGTH_SHORT).show());
    }

    public void toast(int msgId) {
        runOnUiThread(() -> Toast.makeText(this, msgId, Toast.LENGTH_SHORT).show());
    }
}
