package com.jxit.sdkdemo;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.databinding.DataBindingUtil;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Toast;

import com.jxit.printer.jxsdk.JXLog;
import com.jxit.sdkdemo.databinding.ActivityMainBinding;
import com.jxit.sdkdemo.fragment.CPCLFragment;
import com.jxit.sdkdemo.fragment.ESCFragment;
import com.jxit.sdkdemo.fragment.GlobalFragment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MainActivity extends BaseActivity implements View.OnClickListener {
    private ActivityMainBinding bd;
    private static final String[] PERMISSIONS = new String[]{
            Manifest.permission.ACCESS_COARSE_LOCATION
            , Manifest.permission.ACCESS_FINE_LOCATION
            , Manifest.permission.WRITE_EXTERNAL_STORAGE};
    private static final int REQUEST_PERMISSION = 100;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        initPermission();
        bd = DataBindingUtil.setContentView(this, R.layout.activity_main);
        bd.setClickHandler(this);
    }

    private void checkPermission() {
//        initPermission();
        for (String permission : PERMISSIONS) {
            int result = ActivityCompat.checkSelfPermission(this, permission);
            if (result != PackageManager.PERMISSION_GRANTED) {
                ActivityCompat.requestPermissions(this, PERMISSIONS, REQUEST_PERMISSION);
                return;
            }
        }
    }

    private void initPermission() {
        List<String> mPermissionList = new ArrayList<>();
        // Android 版本大于等于 12 时，申请新的蓝牙权限
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            mPermissionList.add(Manifest.permission.BLUETOOTH_SCAN);
            mPermissionList.add(Manifest.permission.BLUETOOTH_ADVERTISE);
            mPermissionList.add(Manifest.permission.BLUETOOTH_CONNECT);

        }
        //根据实际需要申请权限
        mPermissionList.add(Manifest.permission.ACCESS_COARSE_LOCATION);
        mPermissionList.add(Manifest.permission.ACCESS_FINE_LOCATION);
        mPermissionList.add(Manifest.permission.WRITE_EXTERNAL_STORAGE);

        ActivityCompat.requestPermissions(this, mPermissionList.toArray(new String[0]), 101);
    }

    /**
     * 权限回调
     */
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        //获取权限成功 PERMISSION_GRANTED:可以继续操作;PERMISSION_DENIED必须明确向用户要求权限
        if (requestCode == REQUEST_PERMISSION){
            if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                Toast.makeText(this, R.string.msg_authorized, Toast.LENGTH_SHORT).show();
            } else {
                showWaringDialog();
            }
        }else if (requestCode == 101){
            if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                Toast.makeText(this, R.string.msg_authorized, Toast.LENGTH_SHORT).show();
            } else {
                showWaringDialog();
            }

        }

    }


    private void showWaringDialog() {
        new AlertDialog.Builder(this)
                .setTitle(R.string.dialog_title_warning)
                .setMessage(R.string.dialog_msg_auth_permission)
                .setPositiveButton(R.string.confirm, (dialog, which) -> {
                    // 一般情况下如果用户不授权的话，功能是无法运行的，做退出处理
                    finish();
                }).show();
    }


    @Override
    public void onClick(View v) {
        if (bd.buttonMainGlobal.equals(v)) {
            PrinterManager.FRAGMENT_ID = 0;
        } else if (bd.buttonMainEsc.equals(v)) {
            PrinterManager.FRAGMENT_ID = 1;
        } else if (bd.buttonMainCpcl.equals(v)) {
            PrinterManager.FRAGMENT_ID = 2;
        }
        Intent queryIntent=new Intent(this,HomeActivity.class);
        startActivity(queryIntent);

    }
}
