/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxapi;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import com.jxit.printer.jxapi.JXInterfaceAPI;
import com.jxit.printer.jxapi.UnlockCmd;
import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.utils.SystemUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.UUID;

public class JXBluetoothAPI
implements JXInterfaceAPI {
    private static final String TAG = JXBluetoothAPI.class.getSimpleName();
    private Context context;
    private static final UUID uuid = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    public static final int STATE_OFF = 10;
    public static final int STATE_NONE = 200;
    public static final int STATE_CONNECTED = 203;
    private int connectState;
    private boolean btSupport;
    private BluetoothAdapter btAdapter;
    private BluetoothDevice btDevice;
    private BluetoothSocket btSocket;
    private InputStream is = null;
    private OutputStream os = null;
    private static volatile JXBluetoothAPI mDefault = null;
    public static final int MAX_TIMEOUT = 50000;
    public static final int MIN_TIMEOUT = 200;
    private String mConnectedAddress;
    private int mUnlockType = 0;

    JXBluetoothAPI(Context context) {
        this.context = context.getApplicationContext();
        this.btAdapter = BluetoothAdapter.getDefaultAdapter();
        this.btSupport = this.btAdapter != null;
        this.setConnectState(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JXBluetoothAPI getDefault(@NonNull Context context) {
        if (mDefault != null) return mDefault;
        Class<JXBluetoothAPI> clazz = JXBluetoothAPI.class;
        synchronized (JXBluetoothAPI.class) {
            if (mDefault != null) return mDefault;
            mDefault = new JXBluetoothAPI(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mDefault;
        }
    }

    public boolean isBTSupport() {
        return this.btSupport;
    }

    @SuppressLint(value={"MissingPermission"})
    public String getAddress() {
        return this.btAdapter != null ? this.btAdapter.getAddress() : null;
    }

    @SuppressLint(value={"MissingPermission"})
    public String getName() {
        return this.btAdapter != null ? this.btAdapter.getName() : null;
    }

    public int getBTState() {
        return this.btAdapter != null ? this.btAdapter.getState() : 10;
    }

    public boolean isBTEnabled() {
        return this.btAdapter != null ? this.btAdapter.isEnabled() : false;
    }

    private void setConnectState(int state) {
        this.connectState = state;
    }

    public int getConnectState() {
        return this.connectState;
    }

    @Override
    public void setUnlockType(int type) {
        this.mUnlockType = type;
    }

    @Override
    public boolean isConnected() {
        return this.connectState == 203;
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean openBluetooth() {
        try {
            if (this.btAdapter == null) {
                return false;
            }
            if (!this.btAdapter.isEnabled()) {
                this.btAdapter.enable();
                return true;
            }
        }
        catch (Exception var3) {
            var3.printStackTrace();
            JXLog.e(TAG, "open bluetooth exception: " + var3.getMessage());
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean closeBluetooth() {
        boolean result = true;
        try {
            if (this.btAdapter != null && this.btAdapter.isEnabled()) {
                this.btAdapter.disable();
            }
        }
        catch (Exception var3) {
            var3.printStackTrace();
            JXLog.e(TAG, "close bluetooth exception: " + var3.getMessage());
            result = false;
        }
        return result;
    }

    public boolean setDiscoverable(int time) {
        if (time > 0 && time <= 300) {
            boolean result = true;
            if (this.btAdapter != null) {
                Intent discoverableIntent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
                discoverableIntent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", time);
                this.context.startActivity(discoverableIntent);
            } else {
                result = false;
            }
            return result;
        }
        JXLog.e(TAG, "setDiscoverable error time:" + time);
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean startDiscovery() {
        boolean result;
        if (this.btAdapter != null && this.btAdapter.getState() == 12) {
            if (this.btAdapter.isDiscovering()) {
                this.btAdapter.cancelDiscovery();
            }
            result = this.btAdapter.startDiscovery();
        } else {
            result = false;
        }
        return result;
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean isDiscovering() {
        return this.btAdapter.isDiscovering();
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean cancelDiscovery() {
        boolean result = false;
        if (this.btAdapter.isDiscovering()) {
            result = this.btAdapter.cancelDiscovery();
        }
        return result;
    }

    @SuppressLint(value={"MissingPermission"})
    public Set<BluetoothDevice> getBondedDevices() {
        return this.btAdapter != null ? this.btAdapter.getBondedDevices() : null;
    }

    public boolean createBTBond(BluetoothDevice device) {
        try {
            Method createBondMethod = BluetoothDevice.class.getMethod("createBond", new Class[0]);
            if (createBondMethod != null) {
                createBondMethod.invoke((Object)device, new Object[0]);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "create bt bond exception " + e.getMessage());
            return false;
        }
    }

    public boolean removeBTBond(BluetoothDevice device) {
        try {
            Method m = device.getClass().getMethod("removeBond", null);
            m.invoke((Object)device, (Object[])null);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            JXLog.e(TAG, "remove bt bond exception " + e.getMessage());
            return false;
        }
    }

    public boolean openConnection(String macAddress) {
        JXLog.d(TAG, "openConnection");
        if (this.btAdapter == null) {
            JXLog.e(TAG, "btAdapter is null");
        } else if (!BluetoothAdapter.checkBluetoothAddress((String)macAddress)) {
            JXLog.e(TAG, "bad mac address");
        } else {
            if (this.isConnected()) {
                this.closeConnection();
            }
            this.btDevice = this.btAdapter.getRemoteDevice(macAddress);
            try {
                if (this.connectRfcommSocket(this.btDevice)) {
                    this.is = this.btSocket.getInputStream();
                    this.os = this.btSocket.getOutputStream();
                    this.setConnectState(203);
                    this.mConnectedAddress = macAddress;
                    Thread.sleep(100L);
                    if (!UnlockCmd.unlockIfNecessary(this, this.mUnlockType)) {
                        this.closeConnection();
                        return false;
                    }
                    return true;
                }
            }
            catch (Exception var3) {
                JXLog.e(TAG, "open device exception: " + var3.getMessage());
                var3.printStackTrace();
            }
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    private BluetoothSocket createSocket(BluetoothDevice device) {
        BluetoothSocket socket = null;
        if (Build.VERSION.SDK_INT >= 10 && !SystemUtils.isMediatekPlatform()) {
            Class<BluetoothDevice> cls = BluetoothDevice.class;
            Method m = null;
            try {
                m = cls.getMethod("createInsecureRfcommSocketToServiceRecord", UUID.class);
            }
            catch (NoSuchMethodException var9) {
                var9.printStackTrace();
            }
            if (m != null) {
                try {
                    socket = (BluetoothSocket)m.invoke((Object)device, uuid);
                }
                catch (IllegalArgumentException var6) {
                    var6.printStackTrace();
                }
                catch (IllegalAccessException var7) {
                    var7.printStackTrace();
                }
                catch (InvocationTargetException var8) {
                    var8.printStackTrace();
                }
            }
        } else {
            try {
                socket = device.createRfcommSocketToServiceRecord(uuid);
            }
            catch (IOException var5) {
                var5.printStackTrace();
            }
        }
        return socket;
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean connectRfcommSocket(BluetoothDevice device) {
        boolean result;
        int max_retry_count = 2;
        this.btSocket = this.createSocket(device);
        if (SystemUtils.isMediatekPlatform()) {
            try {
                JXLog.i(TAG, "it is MTK platform");
                Thread.sleep(3000L);
            }
            catch (InterruptedException var6) {
                var6.printStackTrace();
            }
        }
        while (true) {
            try {
                if (this.btSocket != null) {
                    Log.i((String)TAG, (String)"socket connect");
                    this.btSocket.connect();
                    result = true;
                    break;
                }
                Log.e((String)TAG, (String)"socket is null");
                result = false;
            }
            catch (IOException var7) {
                result = false;
                if (this.btSocket == null) break;
                if (var7.getMessage() != null && var7.getMessage().equals("Service discovery failed")) {
                    JXLog.e(TAG, "no service found");
                    if (max_retry_count > 0) {
                        JXLog.i(TAG, "retry");
                        --max_retry_count;
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException var5) {
                            var5.printStackTrace();
                        }
                        continue;
                    }
                    JXLog.e(TAG, "max retry count reached");
                    break;
                }
                JXLog.e(TAG, "connect failed");
                if (var7.getMessage() == null) break;
                JXLog.e(TAG, "error is " + var7.getMessage());
                if (max_retry_count <= 0) break;
                JXLog.i(TAG, "retry");
                --max_retry_count;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException var5) {
                    var5.printStackTrace();
                }
                continue;
            }
            break;
        }
        JXLog.i(TAG, "connectRfcommSocket result =" + result);
        return result;
    }

    @Override
    public boolean closeConnection() {
        JXLog.d(TAG, "closeConnection");
        boolean result = true;
        if (this.btDevice != null) {
            this.btDevice = null;
        }
        try {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
            if (this.os != null) {
                this.os.close();
                this.os = null;
            }
            if (this.btSocket != null) {
                this.btSocket.close();
                this.btSocket = null;
            }
            this.setConnectState(200);
        }
        catch (IOException var3) {
            result = false;
            var3.printStackTrace();
            JXLog.e(TAG, "close device exception: " + var3.getMessage());
        }
        return result;
    }

    public void setBtSocket() {
        this.btSocket = null;
        JXLog.d(TAG, "setBtSocket = null");
    }

    @Override
    public boolean reopenConnection(int timeout) {
        JXLog.d(TAG, "reopenConnection");
        if (this.mConnectedAddress == null) {
            JXLog.e(TAG, "reopenConnection failed, please invoke method openConnection(address) ");
            return false;
        }
        String address = this.mConnectedAddress;
        try {
            this.closeConnection();
            Thread.sleep(20L);
            long tm = SystemClock.elapsedRealtime();
            while (true) {
                boolean succeed;
                if (succeed = this.openConnection(address)) {
                    JXLog.i(TAG, "reopenConnection succeed!");
                    return true;
                }
                if (SystemClock.elapsedRealtime() - tm > (long)timeout) {
                    JXLog.f(TAG, "reopenConnection timeout and failed!");
                    return false;
                }
                Thread.sleep(20L);
            }
        }
        catch (Exception e) {
            JXLog.e(TAG, "reopenConnection exception " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean flushReadBuffer() {
        byte[] buffer = new byte[64];
        if (!this.isConnected()) {
            JXLog.e(TAG, " is not Connected when flushReadBuffer");
            return false;
        }
        if (this.is == null) {
            JXLog.e(TAG, " is is null when flushReadBuffer");
            return false;
        }
        while (true) {
            try {
                int availableBuffer = this.is.available();
                if (availableBuffer == 0) {
                    JXLog.e(TAG, " availableBuffer == 0  when flushReadBuffer");
                    return true;
                }
                if (availableBuffer > 0) {
                    if (availableBuffer > 64) {
                        availableBuffer = 64;
                    }
                    this.is.read(buffer, 0, availableBuffer);
                    JXLog.d_bytes(TAG, "flush Reader ", buffer);
                }
            }
            catch (IOException var5) {
                var5.printStackTrace();
                JXLog.e(TAG, "io exception when flushReadBuffer");
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException var4) {
                var4.printStackTrace();
                JXLog.e(TAG, "sleep exception when flushReadBuffer");
                continue;
            }
            break;
        }
    }

    @Override
    public boolean writeBuffer(byte[] buffer, int offset, int length) {
        JXLog.d_bytes(TAG, "write buffer", buffer);
        return this.writeBuffer(buffer, offset, length, true);
    }

    private boolean writeBuffer(byte[] buffer, int offset, int length, boolean retry) {
        if (!this.isConnected()) {
            return false;
        }
        if (this.btSocket == null) {
            JXLog.e(TAG, "btSocket is null");
            return false;
        }
        if (this.os == null) {
            JXLog.e(TAG, "os is null");
            return false;
        }
        try {
            this.os.write(buffer, offset, length);
            return true;
        }
        catch (IOException var5) {
            JXLog.e(TAG, "io exception when write outStream");
            if (retry) {
                this.closeConnection();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.reopenConnection(10000)) {
                    return this.writeBuffer(buffer, offset, length, false);
                }
                this.closeConnection();
                return false;
            }
            this.closeConnection();
            return false;
        }
    }

    @Override
    public boolean readBuffer(byte[] buffer1, byte[] buffer2, long[] receiveTS, int timeout) {
        if (!this.isConnected()) {
            JXLog.e(TAG, " is not Connected when readBuffer");
            return false;
        }
        if (this.btSocket == null) {
            JXLog.e(TAG, "btSocket is null when readBuffer");
            return false;
        }
        if (this.is == null) {
            JXLog.e(TAG, "is is null when readBuffer");
            return false;
        }
        if (timeout < 200) {
            timeout = 200;
        }
        if (timeout > 20000) {
            timeout = 20000;
        }
        try {
            long start_time = SystemClock.elapsedRealtime();
            int totalLength = buffer1.length + buffer2.length;
            int index = 0;
            boolean isReceiveBuffer1 = true;
            while (true) {
                if (this.is.available() > 0) {
                    int n;
                    while (index < totalLength && (n = this.is.read()) != -1) {
                        if (index == 0) {
                            isReceiveBuffer1 = true;
                        } else if (index == buffer1.length - 1) {
                            receiveTS[0] = SystemClock.elapsedRealtime();
                        } else if (index == buffer1.length) {
                            isReceiveBuffer1 = false;
                        } else if (index == totalLength - 1) {
                            receiveTS[1] = SystemClock.elapsedRealtime();
                        }
                        if (isReceiveBuffer1) {
                            buffer1[index] = (byte)n;
                        } else {
                            buffer2[index - buffer1.length] = (byte)n;
                        }
                        ++index;
                    }
                }
                if (index == totalLength) {
                    JXLog.d_bytes(TAG, "read buffer1", buffer1);
                    JXLog.d_bytes(TAG, "read buffer2", buffer2);
                    return true;
                }
                long cur_time = SystemClock.elapsedRealtime();
                if (cur_time - start_time > (long)timeout) {
                    JXLog.e(TAG, "read timeout and read index is " + index);
                    return false;
                }
                Thread.sleep(20L);
            }
        }
        catch (Exception var11) {
            JXLog.e(TAG, "read exception " + var11.getMessage());
            this.closeConnection();
            return false;
        }
    }

    @Override
    public boolean readBuffer(byte[] buffer, int offset, int length, int timeout) {
        if (!this.isConnected()) {
            JXLog.e(TAG, " is not Connected when readBuffer");
            return false;
        }
        if (this.btSocket == null) {
            JXLog.e(TAG, "btSocket is null when readBuffer");
            return false;
        }
        if (this.is == null) {
            JXLog.e(TAG, "is is null when readBuffer");
            return false;
        }
        if (timeout < 200) {
            timeout = 200;
        }
        if (timeout > 50000) {
            timeout = 50000;
        }
        JXLog.e(TAG, "readFixLengthBytes offset = " + offset);
        JXLog.e(TAG, "readFixLengthBytes timeout = " + timeout);
        if (offset >= 0) {
            return this.readFixLengthBytes(buffer, offset, length, timeout);
        }
        return this.readVariableLengthBytes(buffer, ~offset, timeout);
    }

    private boolean readFixLengthBytes(byte[] buffer, int offset, int length, int timeout) {
        try {
            long start_time = SystemClock.elapsedRealtime();
            int need_read = length;
            int index = 0;
            while (true) {
                JXLog.e(TAG, "readFixLengthBytes start");
                int available = this.is.available();
                JXLog.e(TAG, "readFixLengthBytes available = " + available);
                int read = 0;
                if (available > 0) {
                    int n;
                    JXLog.e(TAG, "readFixLengthBytes available > 0 ");
                    while ((n = this.is.read()) != -1) {
                        JXLog.e(TAG, "readFixLengthBytes is.read  start ");
                        buffer[index++] = (byte)n;
                        JXLog.e(TAG, "readFixLengthBytes buffer[] add");
                        ++read;
                        if (index >= length + offset) {
                            JXLog.d("readFixLengthBytes", "index = " + index + "_length = " + length + " break this read while");
                            break;
                        }
                        JXLog.e(TAG, "readFixLengthBytes index >= length + offset  start");
                        if (read >= available) {
                            JXLog.d("readFixLengthBytes", "available = " + available + "_read = " + read + " break this read while");
                            break;
                        }
                        JXLog.e(TAG, "readFixLengthBytes read >= available  start");
                    }
                    need_read -= read;
                    start_time = SystemClock.elapsedRealtime();
                }
                if (need_read <= 0) {
                    JXLog.d_bytes("readFixLengthBytes", "read", buffer);
                    return true;
                }
                if (SystemClock.elapsedRealtime() - start_time > (long)timeout) {
                    JXLog.e(TAG, "readFixLengthBytes timeout");
                    JXLog.d_bytes("readFixLengthBytes", "read timeout", buffer);
                    return false;
                }
                Thread.sleep(20L);
            }
        }
        catch (Exception var11) {
            JXLog.e(TAG, "read exception " + var11.getMessage());
            this.closeConnection();
            return false;
        }
    }

    private boolean readVariableLengthBytes(byte[] buffer, int nIndex, int timeout) {
        try {
            long start_time = SystemClock.elapsedRealtime();
            int need_read = nIndex + 1;
            int index = 0;
            JXLog.e(TAG, "readVariableLengthBytes start  nIndex = " + nIndex);
            while (true) {
                if (this.is.available() > 0) {
                    int n;
                    while ((n = this.is.read()) != -1) {
                        buffer[index] = (byte)n;
                        --need_read;
                        if (index == nIndex) {
                            need_read = buffer[index];
                        }
                        if (need_read == 0) {
                            JXLog.d_bytes("readVariableLengthBytes", "read", buffer);
                            return true;
                        }
                        ++index;
                    }
                    start_time = SystemClock.elapsedRealtime();
                }
                if (SystemClock.elapsedRealtime() - start_time > (long)timeout) {
                    JXLog.e(TAG, "readVariableLengthBytes timeout");
                    JXLog.d_bytes("readVariableLengthBytes", "read", buffer);
                    return false;
                }
                Thread.sleep(20L);
            }
        }
        catch (Exception var11) {
            JXLog.e(TAG, "read exception " + var11.getMessage());
            this.closeConnection();
            return false;
        }
    }

    public BluetoothDevice getRemoteDevice(String scanAddress) {
        return this.btAdapter.getRemoteDevice(scanAddress);
    }

    @Override
    public boolean isUnlock() {
        if (!UnlockCmd.unlockIfNecessary(this, 2)) {
            this.closeConnection();
            return false;
        }
        return true;
    }
}

