/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.jxsdk;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

final class JXExecutors {
    private static volatile Executor mLogExecutor;
    private static volatile Executor mPrinterExecutor;
    private static final JXExecutors mDefault;

    private JXExecutors() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Executor logger() {
        if (mLogExecutor != null) return mLogExecutor;
        Class<Executor> clazz = Executor.class;
        synchronized (Executor.class) {
            if (mLogExecutor != null) return mLogExecutor;
            mLogExecutor = new Executor(mDefault, 1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mLogExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Executor printer() {
        if (mPrinterExecutor != null) return mPrinterExecutor;
        Class<JXExecutors> clazz = JXExecutors.class;
        synchronized (JXExecutors.class) {
            if (mPrinterExecutor != null) return mPrinterExecutor;
            mPrinterExecutor = new Executor(mDefault, 1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mPrinterExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Class<JXExecutors> clazz = JXExecutors.class;
        synchronized (JXExecutors.class) {
            if (mPrinterExecutor != null) {
                mPrinterExecutor.shutdownNow();
                mPrinterExecutor = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        mDefault = new JXExecutors();
    }

    public static class Executor {
        private final ExecutorService mPool;
        public JXExecutors factory;

        public Executor(JXExecutors factory, int threads) {
            this.factory = factory;
            this.mPool = threads <= 1 ? Executors.newSingleThreadExecutor() : Executors.newFixedThreadPool(threads);
        }

        public void execute(Runnable runnable) {
            this.mPool.execute(runnable);
        }

        public <T> Future<T> execute(Callable<T> callable) {
            return this.mPool.submit(callable);
        }

        public void shutdownNow() {
            this.mPool.shutdownNow();
        }
    }
}

