/*
 * Decompiled with CFR 0.152.
 */
package com.jxit.printer.model;

import com.jxit.printer.jxsdk.JXLog;
import com.jxit.printer.utils.SDKUtil;

public class JXFirmwareFontUpgrade {
    public static int SUCCESS = 0;
    public static int ERROR_UPGRADE_MODE = 1;
    public static int ERROR_FILE_ZERO_SIZE = 2;
    public static int ERROR_FILE_OVER_SIZE = 3;
    public static int ERROR_NOT_DEFINED = 4;

    public static byte[] createUpgradeModeCheckCMD() {
        return new byte[]{16, 8, 0, 0, 0, -1, -1};
    }

    public static boolean parseUpgradeModeCheck(byte[] data) {
        JXLog.d_bytes("JXFirmwareFontUpgrade", "parseUpgradeModeCheck", data);
        return data != null && data.length == 4 && data[0] == 16 && data[1] == 8 && data[2] == 0 && data[3] == 0;
    }

    public static byte[] createUpgradeFileSizeCheckCMD(int size, boolean isFont) {
        int crc = SDKUtil.crc(new byte[]{(byte)(size & 0xFF), (byte)(size >> 8 & 0xFF), (byte)(size >> 16 & 0xFF), (byte)(size >> 24 & 0xFF)});
        return new byte[]{16, 8, (byte)(isFont ? 2 : 1), 4, 0, (byte)(size & 0xFF), (byte)(size >> 8 & 0xFF), (byte)(size >> 16 & 0xFF), (byte)(size >> 24 & 0xFF), (byte)(crc & 0xFF), (byte)(crc >> 8 & 0xFF)};
    }

    public static int parseUpgradeFileSizeCheckCMD(byte[] data, boolean isFont) {
        JXLog.d_bytes("JXFirmwareFontUpgrade", "parseUpgradeFileSizeCheckCMD font=" + isFont, data);
        if (data != null && data.length == 4 && isFont ? data[2] == 2 : data[2] == 1) {
            if (data[3] == 0) {
                return SUCCESS;
            }
            if (data[3] == -3) {
                return ERROR_FILE_ZERO_SIZE;
            }
            if (data[3] == -4) {
                return ERROR_FILE_OVER_SIZE;
            }
            JXLog.e("JXFirmwareFontUpgrade", "parseUpgradeFileSizeCheckCMD not defined response " + data[3]);
            return ERROR_NOT_DEFINED;
        }
        return ERROR_NOT_DEFINED;
    }

    public static byte[] createUpgradeFileUploadCMD(byte[] data, boolean isFont) {
        byte[] cmd = new byte[data.length + 7 + 1];
        cmd[0] = 16;
        cmd[1] = 8;
        cmd[2] = (byte)(isFont ? 4 : 3);
        cmd[3] = (byte)(data.length & 0xFF);
        cmd[4] = (byte)(data.length >> 8 & 0xFF);
        int crc = SDKUtil.crc(data);
        cmd[cmd.length - 3] = (byte)(crc & 0xFF);
        cmd[cmd.length - 2] = (byte)(crc >> 8 & 0xFF);
        cmd[cmd.length - 1] = 0;
        System.arraycopy(data, 0, cmd, 5, data.length);
        return cmd;
    }

    public static boolean parseUpgradeFileUpload(byte[] data, boolean isFont) {
        JXLog.d_bytes("JXFirmwareFontUpgrade", "parseUpgradeFileUpload font=" + isFont, data);
        return data != null && data.length == 4 && data[2] == (isFont ? (byte)4 : 3) && data[3] == 0;
    }

    public static boolean parseUpgradeRestartCheck(byte[] data) {
        JXLog.d_bytes("JXFirmwareFontUpgrade", "parseUpgradeRestartCheck ", data);
        return data != null && data.length == 4 && data[2] == 16 && data[3] == 0;
    }

    public static byte[] createUpgradeRestartCMD() {
        return new byte[]{16, 8, 16, 0, 0, -1, -1};
    }
}

