package com.jxit.sdkdemo.fragment;

import android.app.Activity;
import android.hardware.usb.UsbDevice;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import com.jxit.printer.jxapi.JXUsbAPI;
import com.jxit.sdkdemo.PrinterManager;
import com.jxit.sdkdemo.R;
import com.jxit.sdkdemo.databinding.FragmentUsbConnectBinding;

import java.util.List;

public class UsbFragment extends Fragment {

    private FragmentUsbConnectBinding bd;
    private JXUsbAPI mApi;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (bd == null) {
            bd = FragmentUsbConnectBinding.inflate(inflater, container, false);
            bd.btnConnect.setOnClickListener(v -> {
                refreshLayout();
                Toast.makeText(getContext(), R.string.usb_connect_detect_finish, Toast.LENGTH_SHORT).show();
            });
        }
        refreshLayout();
        return bd.getRoot();
    }

    private void refreshLayout() {
        mApi = JXUsbAPI.getDefault(getContext());
        List<UsbDevice> devices = mApi.getDevices();
        if (devices.isEmpty()) {
            bd.tvDevice.setText(R.string.usb_no_device_detected);
            bd.tvConnectedDevice.setText(R.string.no_device_connected);
        } else {
            if (PrinterManager.getInstance().isConnected(PrinterManager.CONNECT_USB)) {
                UsbDevice device = PrinterManager.getInstance().getConnectUsbDevice();
                if (device != null) {
                    String title = getString(R.string.device_connected);
                    bd.tvConnectedDevice.setText(title + ": " + device.getDeviceName());
                }
            }
            bd.tvDevice.setText(devices.get(0).getDeviceName());
            bd.tvDevice.setOnClickListener(v -> {
                UsbDevice device = devices.get(0);
                PrinterManager.getInstance().closeConnection();
                if (mApi.openConnection(device)) {
                    PrinterManager.getInstance().setAPI(mApi, device);
                    Toast.makeText(getContext(), R.string.connect_success, Toast.LENGTH_SHORT).show();
                    getActivity().setResult(Activity.RESULT_OK);
                    getActivity().finish();
                } else {
                    Toast.makeText(getContext(), R.string.connect_fail, Toast.LENGTH_SHORT).show();
                }
            });
        }

    }
}
